<?php
require_once __DIR__ . '/../helpers/auth.php';
require_role('guru');
$me = current_user();
// absensi count per status for this guru
$stmt = $pdo->prepare('SELECT status, COUNT(*) as cnt FROM absensi WHERE id_guru=? GROUP BY status');
$stmt->execute([$me['id']]);
$abs_stat = $stmt->fetchAll(PDO::FETCH_KEY_PAIR);

// jurnal list
$stmt = $pdo->prepare('SELECT j.*, k.nama as kelas_n, m.nama as mapel_n FROM jurnal j JOIN kelas k ON k.id=j.id_kelas JOIN mapel m ON m.id=j.id_mapel WHERE j.id_guru=? ORDER BY j.tanggal DESC LIMIT 200');
$stmt->execute([$me['id']]);
$jurnal = $stmt->fetchAll();
?>
<!doctype html><html><head><meta charset='utf-8'><meta name='viewport' content='width=device-width,initial-scale=1'>
<link href='https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css' rel='stylesheet'>
<title>Rekap Pribadi</title><style>:root{--madrasah-green:#1e7e34}.navbar{background:var(--madrasah-green)}</style></head>
<body>
<nav class='navbar navbar-dark'><div class='container-fluid'><a class='navbar-brand'>Guru - Rekap</a><div class='d-flex'><a class='btn btn-outline-light btn-sm' href='/public/logout.php'>Logout</a></div></div></nav>
<div class='container py-4'>
  <div class='row'><div class='col-md-4'>
    <h5>Ringkasan Absensi</h5>
    <ul class='list-group'>
      <li class='list-group-item'>Hadir: <?php echo $abs_stat['hadir'] ?? 0;?></li>
      <li class='list-group-item'>Sakit: <?php echo $abs_stat['sakit'] ?? 0;?></li>
      <li class='list-group-item'>Ijin: <?php echo $abs_stat['ijin'] ?? 0;?></li>
      <li class='list-group-item'>Alpha: <?php echo $abs_stat['alpha'] ?? 0;?></li>
    </ul>
  </div>
  <div class='col-md-8'>
    <h5>Jurnal Terakhir</h5>
    <table class='table table-sm'><thead><tr><th>Tanggal</th><th>Mapel</th><th>Kelas</th><th>Materi</th></tr></thead><tbody>
    <?php foreach($jurnal as $j): ?><tr><td><?php echo $j['tanggal'];?></td><td><?php echo htmlspecialchars($j['mapel_n']);?></td><td><?php echo htmlspecialchars($j['kelas_n']);?></td><td><?php echo htmlspecialchars(substr($j['materi'],0,120));?></td></tr><?php endforeach;?>
    </tbody></table>
  </div></div>
</div>
</body></html>
