<?php
require_once __DIR__ . '/../helpers/auth.php';
require_role('admin');
if($_SERVER['REQUEST_METHOD'] === 'POST'){
  $nis = trim($_POST['nis'] ?? '');
  $nama = trim($_POST['nama'] ?? '');
  $id_kelas = (int)($_POST['id_kelas'] ?? 0);
  if($nis && $nama && $id_kelas){
    $stmt = $pdo->prepare('INSERT INTO siswa (nis,nama,id_kelas) VALUES (?,?,?)');
    $stmt->execute([$nis,$nama,$id_kelas]);
    header('Location: siswa.php'); exit;
  }
}
$kelas = $pdo->query('SELECT * FROM kelas')->fetchAll();
$siswa = $pdo->query('SELECT s.*, k.nama as kelas_n FROM siswa s JOIN kelas k ON k.id = s.id_kelas ORDER BY s.id')->fetchAll();
?>
<!doctype html><html><head><meta charset='utf-8'><meta name='viewport' content='width=device-width,initial-scale=1'>
<link href='https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css' rel='stylesheet'>
<title>Kelola Siswa</title><style>:root{--madrasah-green:#1e7e34}.navbar{background:var(--madrasah-green)}</style></head>
<body>
<nav class='navbar navbar-dark'><div class='container-fluid'><a class='navbar-brand'>Admin - Siswa</a><div class='d-flex'><a class='btn btn-outline-light btn-sm' href='/public/logout.php'>Logout</a></div></div></nav>
<div class='container py-4'><div class='row'><div class='col-md-4'><h5>Tambah Siswa</h5>
<form method='post'>
  <div class='mb-2'><label>NIS</label><input name='nis' class='form-control' required></div>
  <div class='mb-2'><label>Nama</label><input name='nama' class='form-control' required></div>
  <div class='mb-2'><label>Kelas</label><select name='id_kelas' class='form-select' required><?php foreach($kelas as $k): ?><option value='<?php echo $k['id']; ?>'><?php echo htmlspecialchars($k['nama']);?></option><?php endforeach;?></select></div>
  <button class='btn btn-success w-100'>Tambah</button>
</form></div>
<div class='col-md-8'><h5>Daftar Siswa</h5><table class='table'><thead><tr><th>NIS</th><th>Nama</th><th>Kelas</th></tr></thead><tbody><?php foreach($siswa as $s): ?><tr><td><?php echo htmlspecialchars($s['nis']);?></td><td><?php echo htmlspecialchars($s['nama']);?></td><td><?php echo htmlspecialchars($s['kelas_n']);?></td></tr><?php endforeach;?></tbody></table></div></div></div>
</body></html>
